<%@ Page Language="C#" AutoEventWireup="true" Inherits="Users_User_Verticals_Verticals" Codebehind="Verticals.aspx.cs" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">
  <title>Untitled Page</title>
  <script language="javascript" type="text/javascript" src="../../../Includes/JS_Functions.js" enableviewstate="false"></script>
  <script language="javascript" type="text/javascript" src="../../../Includes/easyAjax.js" enableviewstate="false"></script>
  <script language="javascript" type="text/javascript" enableviewstate="false">
    //<![CDATA[
    // Modifico el atributo userTypeName de los checkbox
    function ChangeUserType(pSelectElement)
    {
      pSelectElement.setAttribute('userTypeName', pSelectElement.options[pSelectElement.selectedIndex].value);
    }
    
    function ValidateAssignVerticals(pUsrId, msgTheLicense, msgTheUserTypeMain, msgTheUserTypeSecondary, strMsgAssignVerticals, pMsgInvalidChangeUserType, pMsgSingleProfile)
    {
      var objInputs;
      var objInput;
      var objInputsSelect;
      var objInputSelect;
      var isAnyVerticalAssigned;
      var strMessageUserType;
      
      // Antes que nada valido si la base no fue manipulada en forma manual
      // por un usuario malintencionado
      if (validateDataBaseIsModificated() == true)
        return false;

      // Search on all Input Tags.
      objInputs = document.getElementsByTagName('input');
      isAnyVerticalAssigned = false;
      for (var i = 0; i < objInputs.length - 1; i++)
      {
        // Get Input that acts as a Filter
        objInput = objInputs.item(i);
        if (objInput.type.toUpperCase() == 'CHECKBOX')
        {
          // Consulto por el nodo Padre y por el nodo propio
          if (objInput.parentNode.getAttribute('category') != null && objInput.parentNode.getAttribute('category') == 'chkSelVertical')
          {
            if (objInput.checked == true)
            {
              isAnyVerticalAssigned = true; // indico que al menos un vertical se encuentra asignado
              
              // controlo licencia en PECTRA BPM Suite
              if (objInput.parentNode.getAttribute('verticalName').toUpperCase() == 'PECTRA' || objInput.parentNode.getAttribute('verticalName').toUpperCase() == 'PECTRA BPM SUITE')
              {                
                if (validateLicense('PECTRA BPM Suite', 'UsrMain', pUsrId, msgTheLicense, msgTheUserTypeMain) == false)
                {
                  return false; //cancelo el submit de la pagina
                }
              }
              
              // controlo licencia en Verticales
              objInputsSelect = document.getElementsByTagName('select');
              for (var j = 0; j < objInputsSelect.length; j++)
              {
                // Get Input that acts as a Filter
                objInputSelect = objInputsSelect.item(j);
                if (objInputSelect.type.toUpperCase() == 'SELECT-ONE')
                {                  
                  if (objInputSelect.getAttribute('verticalName') == objInput.parentNode.getAttribute('verticalName'))
                  {
                    switch (objInputSelect.getAttribute('userTypeName').toUpperCase())
                    {
                      case 'USRMAIN':
                        strMessageUserType = msgTheUserTypeMain;
                        break;
                      case 'USRSECONDARY':
                        strMessageUserType = msgTheUserTypeSecondary;
                        break;
                      default:
                        strMessageUserType = msgTheUserTypeMain;
                        break;
                    }

                    // verifico si la licencia permite agregar un nuevo usuario al vertical
                    if (validateLicense(objInputSelect.getAttribute('verticalName'), objInputSelect.getAttribute('userTypeName'), pUsrId, msgTheLicense, strMessageUserType) == false)
                    {
                      objInputSelect.focus(); //asigno el foco al objeto "select"
                      return false; //cancelo el submit de la pagina
                    }
                  }
                } //-End If-
              } //-End For-
            } //-End If-
          }
        }
      }

      if (isAnyVerticalAssigned == false)
      {
        alert(strMsgAssignVerticals + '.');
        return false;
      }
      
      if (ValidateIsPosibleChangeUserType(pUsrId, 'chkSelVertical', pMsgInvalidChangeUserType, pMsgSingleProfile) == false)
        return false;
      
      return true;
      
    } //-End Function-
    
    // Valido si un vertical permite asignar mas usuarios segun su tipo
    function validateLicense(pVerticalName, pUserTypeName, pUsrId, msgTheLicense, msgTheUserType)
    {
      var rand;
      var blnIsValidNewUser;
      var ea = new easyAjax();

      rand = Math.random();
      blnIsValidNewUser = false;

      ea.openText("../ValidateUserCountByVerticalByUserType.aspx?VerticalName=" + pVerticalName + "&UserTypeName=" + pUserTypeName + "&UserId=" + pUsrId + "&nocache=" + rand, function(szResult){
        if (szResult.toUpperCase() == 'TRUE')
          blnIsValidNewUser = true;
      });
      
      if (blnIsValidNewUser == false) //si la licencia no permite mas usuarios informo al usuario
      {
        alert(msgTheLicense + ' \'' + pVerticalName + '\' ' + msgTheUserType + '.');
      }
      
      return blnIsValidNewUser;
    } //-End Function-
    
    // Valido si la base de datos fue manipulada en forma manual
    function validateDataBaseIsModificated()
    {
      var blnResult;
      var ea = new easyAjax();

      rand = Math.random();
      blnIsModificated = false;

      ea.openText("../ValidateDataBaseIsCorrect.aspx", function(szResult){
        if (szResult.toUpperCase() == 'TRUE')
          blnIsModificated = true;
      });
      
      if (blnIsModificated == true)
        alert('The relationship between users and verticals has been changed by one malicious user.\n\rPlease contact to Pectra Support.');
      
      return blnIsModificated;
    }//-End Function-
    
    // Valida si un usuario puede ser cambiado de tipo de usuario "Full" a "Trimmed"
    function ValidateIsPosibleChangeUserType(pUsrId, pCategory, pMsgInvalidChangeUserType, pMsgSingleProfile)
    {
      var objInputs;
      var objInput;
      var objInputsSelect;
      var objInputSelect;
      var strVerticalName;
      var ea = new easyAjax();
      var rand;
      var blnResult;

      // Search on all Input Tags.
      objInputs = document.getElementsByTagName('input');
      rand = Math.random();
      blnResult = true;
      
      for (var i = 0; i < objInputs.length - 1; i++)
      {
        // Get Input that acts as a Filter
        objInput = objInputs.item(i);
        if (objInput.type.toUpperCase() == 'CHECKBOX')
        {
          // Consulto si los atributos que necesito coinciden
          if (objInput.parentNode.getAttribute('category') != null && objInput.parentNode.getAttribute('category') == pCategory && objInput.parentNode.getAttribute('verticalName') != null && objInput.checked == true)
          {
            strVerticalName = objInput.parentNode.getAttribute('verticalName');

            // Search on all Input Tags.
            objInputsSelect = document.getElementsByTagName('select');
            // recorro cada select buscando el asociado al checkbox actual
            for (var j = 0; j < objInputsSelect.length; j++)
            {
              // Get Input that acts as a Filter
              objInputSelect = objInputsSelect.item(j);
              if (objInputSelect.type.toUpperCase() == 'SELECT-ONE')
              {
                if (objInputSelect.getAttribute('verticalName') != null && objInputSelect.getAttribute('verticalName') == strVerticalName && objInputSelect.getAttribute('userTypeName') != null && objInputSelect.getAttribute('userTypeName') == 'UsrSecondary')
                {
                  // verifico si es posible cambiar el tipo de usuario
                  ea.openText("ValidateChangeUserType.aspx?UsrId=" + pUsrId + "&VerticalName=" + strVerticalName + "&nocache=" + rand, function(szResult){
                    if (szResult.toUpperCase() == 'FALSE')
                    {
                      blnResult = false;
                      objInputSelect.focus();
                      // informo al usuario del no cambio de tipo de usuario para un vertical
                      alert(pMsgInvalidChangeUserType + ' \'' + strVerticalName + '\'. \n\r' + pMsgSingleProfile + '.');
                    }
                  });
                }
              }
            }
          }
        } //-End If-
      } //-End For-

      return blnResult;
      
    } //-End Function-
    //]]>
  </script>
</head>
<body onload="javascript:calcHeight('ContentArea');">
  <form id="form1" runat="server">
    <div>
      <!-- Panel de Propiedades Adicionales -->
      <asp:Panel ID="pnlFilter" CssClass="Filter" runat="server" Width="100%" EnableViewState="False">
        <table border="0" cellpadding="2" cellspacing="0" style="width: 100%">
          <tr>
            <td id="tdCaption" class="FilterCaption" style="width: 100%">
              <img id="imgTitle" alt="Definicin de idioma" src="../../../Images/ProfUsers16.gif"
                class="Filter" />
                <span id="spanAssingVerticals" runat="server">Asignacion de verticales</span>
            </td>
          </tr>
        </table>
        <hr class="Separator" />
        <!-- Grilla de Idiomas -->
        <table border="0" cellpadding="2" cellspacing="0" style="width: 100%">
          <tr>
            <td id="td1" class="FilterCaption" style="width: 30%">
                <span id="spanVerticals" runat="server">Verticales</span>
            </td>
            <td style="width: 70%" class="FilterCaptionContinue" align="right">
              <asp:Button ID="btnUnCheckAllVerticals" runat="server" SkinID="Filter" Text="Desmarcar Todo" EnableViewState="False" />
              <asp:Button ID="btnCheckAllVerticals" runat="server" SkinID="Filter" Text="Marcar Todo" EnableViewState="False" />
              <asp:Button ID="btnReverseVerticals" runat="server" SkinID="Filter" Text="Invertir" EnableViewState="False" />
            </td>
          </tr>
        </table>
        <table border="0" cellpadding="2" cellspacing="0" style="width: 100%">
          <tr>
            <td>
              <asp:GridView ID="gridVerticals" runat="server" AutoGenerateColumns="False"
                  SkinID="Filter" OnRowDataBound="gridVerticals_RowDataBound" >
                <PagerSettings FirstPageImageUrl="~/Images/NavFirstPage.gif" FirstPageText="First"
                  LastPageImageUrl="~/Images/NavLastPage.gif" LastPageText="Last" Mode="NumericFirstLast"
                  PageButtonCount="10" />
                <Columns>
                  <asp:BoundField DataField="Id" HeaderText="Id de Vertical" ReadOnly="True" SortExpression="Id">
                    <ItemStyle Width="35%" Wrap="False" />
                  </asp:BoundField>
                  <asp:TemplateField HeaderText="Tipo de Usuario">
                    <ItemStyle HorizontalAlign="Center" Width="45%" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                      <asp:DropDownList ID="ddlUserType" runat="server" SkinID="Filter" verticalName='<%# Eval("Id") %>' userTypeName="" onchange="javascript:ChangeUserType(this)" EnableViewState="false"></asp:DropDownList>               
                    </ItemTemplate>
                  </asp:TemplateField>
                  <asp:TemplateField HeaderText="Seleccionar">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                      <asp:CheckBox ID="chkSelVertical" runat="server" category="chkSelVertical" verticalName='<%# Eval("Id") %>' />                  
                    </ItemTemplate>
                  </asp:TemplateField>
                </Columns>
              </asp:GridView>
            </td>
          </tr>
        </table>

        <!-- Botones de Confirmacion de Pie de Pagina -->
        <table border="0" cellpadding="0" cellspacing="0" style="width: 100%">
          <tr>
            <td align="right">
              <br />
              <hr class="Separator" />
              <asp:Button ID="btnOk" runat="server" SkinID="Filter" Text="Aceptar" EnableViewState="False" OnClick="btnOk_Click" />
              <asp:Button ID="btnCancel" runat="server" SkinID="Filter" Text="Salir" EnableViewState="False" OnClick="btnCancel_Click" />
              <hr class="Separator" />
              <br />
            </td>
          </tr>
        </table>
      </asp:Panel>
    </div>
    </form>
</body>
</html>
